unit UMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Math, Buttons;

type
  TMain = class(TForm)
    edFileName: TEdit;
    meShowLine: TMemo;
    btPrev: TButton;
    btNext: TButton;
    lbCurrent: TLabel;
    btCleanse: TButton;
    OpenDialog: TOpenDialog;
    sbOpenFile: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btPrevClick(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure btCleanseClick(Sender: TObject);
    procedure sbOpenFileClick(Sender: TObject);
  private
    IniFile : string;
  public
    procedure RefreshMemo;
    function  Cleanse(Str : string) : string;
  end;

var
  Main : TMain;
  SL   : TStringList;
  Iterator : integer = 0;
implementation



{$R *.dfm}

procedure TMain.RefreshMemo;
begin
  meShowLine.Text := SL[Iterator];
  lbCurrent.Caption := 'Line : ' + IntToStr(Iterator);
end;

procedure TMain.FormCreate(Sender: TObject);
var TempSL : TStringList;
begin
  IniFile := ExtractFilePath(Application.ExeName) + 'PocPars.ini';
  SL := TStringList.Create;
  if FileExists(IniFile) then
  begin
    TempSL := TStringList.Create; // lazy no?
    TempSL.LoadFromFile(IniFile);
    edFileName.Text := TempSL[0];
    TempSL.Free;
  end;
end;

procedure TMain.FormDestroy(Sender: TObject);
begin
  SL.Free;
end;

procedure TMain.btPrevClick(Sender: TObject);           
begin
  Dec(Iterator);
  Iterator := Max(0, Iterator);
  RefreshMemo;
end;

procedure TMain.btNextClick(Sender: TObject);
begin
  inc(Iterator);
  Iterator := Min(SL.Count -1, Iterator);
  RefreshMemo;
end;

procedure TMain.btCleanseClick(Sender: TObject);
var i   : integer;
    Str : string;
begin
  if not FileExists(edFileName.Text) then Exit;
  try
    Str := Caption;
    Caption := 'Performing the requested operation...';
    Screen.Cursor := crHourGlass;
    Application.ProcessMessages;
    SL.Clear;
    SL.LoadFromFile(edFileName.Text);
    for i := 0 to SL.Count -1 do
    begin
      if (Pos('endgoal', SL[i]) > 0)
      or (Pos('preference', SL[i]) > 0) then
      begin
        Iterator := i;
        RefreshMemo;
        Application.ProcessMessages;
        SL[i] := Cleanse(SL[i]);
        RefreshMemo;
        Application.ProcessMessages;
      end;
    end;
    SL.SaveToFile(edFileName.Text);
  finally
    Screen.Cursor := crDefault;
    Caption := Str;
    meShowLine.Text := 'Operation completed, mailto : phmalacher@free.fr for problems';
  end;
end;

function TMain.Cleanse(Str : string) : string;
var  i        : integer;
     TempSL   : TStringList;
     StartPos : integer;
     EndPos   : integer;
     Header   : string;
     SubStr   : string;
begin
  Result := Str;
  TempSL := TStringList.Create;
  TempSL.Sorted := True;
  TempSL.Duplicates := dupIgnore;

  try
    // search the first numerical character in the string
    for i := 1 to Length(Str) do
    begin
      if not (Str[i] in ['0'..'9']) then Continue;
      Break;
    end;
    StartPos := i;
    EndPos   := i;
    Header := Copy(Str, 1, StartPos-1);

    repeat
      while Str[EndPos] in ['0'..'9'] do
      begin
        Inc(EndPos);
        // end of the line
        if EndPos = Length(Str) then
        begin
          TempSL.Add(Copy(Str, StartPos, EndPos-StartPos + 1));
          Break;
        end;
      end;//redo a loop until EndPos is not a numerical char

      // the other cases
      SubStr := Copy(Str, StartPos, EndPos-StartPos + 1);
      if (SubStr = '') or (SubStr = '}') then Break;
      TempSL.Add(SubStr);

      StartPos := EndPos + 1;
      EndPos := StartPos;
    until
      StartPos >= Length(Str);

    if TempSL.Count = 0 then Exit;
    Result := Header;
    for i := 0 to TempSL.Count -1 do Result := Result + TempSL[i] + ' ';
    Result := Result + '}';

  finally
    TempSL.Free;
  end;
end;

procedure TMain.sbOpenFileClick(Sender: TObject);
var TempSL : TStringList;
begin
  OpenDialog.Execute;
  edFileName.Text := OpenDialog.FileName;
  if FileExists(edFileName.Text) then
  begin
    TempSL := TStringList.Create;
    TempSL.Add(edFileName.Text);
    // very lazy I know
    TempSL.SaveToFile(IniFile);
    TempSL.Free;
  end;
end;

end.
